package examples.entity.intro;

import java.io.Serializable;

import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.EntityListener;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Version;

/**
 * This demo entity represents a Bank Account.
 * <p>
 * The entity is not a remote object and can only be accessed locally by
 * clients. However, it is made serializable so that instances can be passed by
 * value to remote clients for local inspection.
 * <p>
 * Access to persistent state is by direct field access.
 */

@Entity(access = AccessType.FIELD)
@EntityListener(MyListener.class)
@NamedQuery(name="findThem", query="SELECT a FROM Account a")
public class Account implements Serializable {

    /** The account number is the primary key for the persistent object */
    @Id
    public int accountNumber;

    public String ownerName;

    public int balance;
    
    @Version
    public int version;

    /**
     * Entity beans must have a public no-arg constructor
     */
    public Account() {
        // our own primary key generation, workaround for the
        // time being as Glassfish persistence does not support
        // auto-generation
        accountNumber = (int) System.nanoTime();
    }

    public String toString() {
        return "Acc.# " + accountNumber + ", owner" + ownerName + ", balance: " + balance
                + " $";
    }

    @PrePersist
    void prepersist() {
        System.out.println("pre persist!!");
    }
    
    @PreUpdate
    void preupdate() {
        System.out.println("pre update!!");
    }
    
    @PostUpdate
    void postupdate() {
        System.out.println("post update!!");
    }
    
    @PostLoad
    void postload() {
        System.out.println("post load!!");
    }
    
}
